/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class AxisController
extends DomNodeController {
    DasAxis dasAxis;
    private DasColumn column;
    private DasRow row;
    private Application dom;
    Plot plot;
    final Axis axis;
    private static final Object PENDING_RANGE_TWEAK = "pendingRangeTweak";
    private boolean defaultOppositeRight = false;
    private final PropertyChangeListener rangeChangeListener = new PropertyChangeListener(){

        private DatumRange logCheckRange(DatumRange range, boolean log) {
            Units u = range.getUnits();
            double dmin = range.min().doubleValue(u);
            double dmax = range.max().doubleValue(u);
            boolean changed = false;
            if (log && dmax <= 0.0) {
                dmax = 1000.0;
                changed = true;
            }
            if (log && dmin <= 0.0) {
                dmin = dmax / 10000.0;
                changed = true;
            }
            if (changed) {
                return new DatumRange(dmin, dmax, u);
            }
            return range;
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
            if (((AxisController)AxisController.this).dom.controller.isValueAdjusting() || AxisController.this.valueIsAdjusting()) {
                return;
            }
            if (evt.getPropertyName().equals("range") || evt.getPropertyName().equals("log")) {
                AxisController.this.axis.setAutoRange(false);
            }
            switch (evt.getPropertyName()) {
                case "label": {
                    AxisController.this.axis.setAutoLabel(false);
                    break;
                }
                case "log": {
                    if (AxisController.this.isPendingChanges()) {
                        return;
                    }
                    DatumRange oldRange = AxisController.this.axis.range;
                    DatumRange range = this.logCheckRange(AxisController.this.axis.range, AxisController.this.axis.log);
                    if (range.equals((Object)oldRange)) break;
                    if (new Exception().getStackTrace().length > 280) {
                        AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.axis.setLog(false);
                        AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                        break;
                    }
                    AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.axis.setRange(range);
                    AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                    break;
                }
                case "range": {
                    if (AxisController.this.isPendingChanges()) {
                        return;
                    }
                    DatumRange oldRange = AxisController.this.axis.range;
                    DatumRange range = this.logCheckRange(AxisController.this.axis.range, AxisController.this.axis.log);
                    if (!range.equals((Object)oldRange)) {
                        if (new Exception().getStackTrace().length > 280) {
                            AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                            AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                            AxisController.this.axis.setLog(false);
                            AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                        } else {
                            AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                            AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                            if (AxisController.this.axis.isLog()) {
                                AxisController.this.axis.setLog(false);
                            }
                            AxisController.this.axis.setRange(range);
                            AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                        }
                    }
                    AxisController.this.dasAxis.setLabel((String)AxisController.this.labelConverter.convertForward(AxisController.this.axis.getLabel()));
                    break;
                }
                case "scale": {
                    DatumRange otherRange;
                    Datum otherw;
                    Datum otherScale;
                    Datum scale;
                    double expand;
                    if (AxisController.this.dasAxis == null) break;
                    int npixels = AxisController.this.dasAxis.isHorizontal() ? AxisController.this.dasAxis.getColumn().getWidth() : AxisController.this.dasAxis.getRow().getHeight();
                    Units u = AxisController.this.dasAxis.getUnits();
                    Datum w = u != u.getOffsetUnits() ? AxisController.this.axis.getRange().width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(AxisController.this.axis.getRange().max().divide(AxisController.this.axis.getRange().min()).value())) : AxisController.this.axis.getRange().width());
                    Datum oldScale = w.divide((double)npixels);
                    Datum newScale = (Datum)evt.getNewValue();
                    if (!oldScale.getUnits().isConvertibleTo(newScale.getUnits())) {
                        return;
                    }
                    if (oldScale.equals(newScale) || !(Math.abs(expand = ((scale = (Datum)evt.getNewValue()).divide(otherScale = (otherw = (u = (otherRange = AxisController.this.dasAxis.getDatumRange()).getUnits()) != u.getOffsetUnits() ? otherRange.width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(otherRange.max().divide(otherRange.min()).value())) : otherRange.width())).divide((double)npixels)).value() - 1.0) / 2.0) > 1.0E-4)) break;
                    DomNodeController.logger.log(Level.FINER, "expand={0} scale={1} otherScale={2}", new Object[]{expand, scale, otherScale});
                    try {
                        DatumRange newOtherRange = AxisController.this.dasAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)otherRange, (double)(0.0 - expand), (double)(1.0 + expand)) : DatumRangeUtil.rescale((DatumRange)otherRange, (double)(0.0 - expand), (double)(1.0 + expand));
                        AxisController.this.axis.setRange(newOtherRange);
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("here129");
                    }
                    break;
                }
            }
        }
    };
    protected LabelConverter labelConverter;
    private final PropertyChangeListener scaleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DomNodeController.logger.finer("scaleListener");
            if (AxisController.this.dasAxis == null) {
                return;
            }
            int npixels = AxisController.this.dasAxis.isHorizontal() ? AxisController.this.dasAxis.getColumn().getWidth() : AxisController.this.dasAxis.getRow().getHeight();
            Units u = AxisController.this.dasAxis.getUnits();
            Datum w = u.getOffsetUnits() != u ? AxisController.this.axis.getRange().width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(AxisController.this.axis.getRange().max().divide(AxisController.this.axis.getRange().min()).value())) : AxisController.this.axis.getRange().width());
            boolean rangeWasChanged = evt.getPropertyName().equals("range");
            Datum scale = w.divide((double)npixels);
            if (!AxisController.this.axis.getScale().equals(scale)) {
                List<BindingModel> bms = AxisController.this.dom.getController().findBindings(AxisController.this.axis, "scale");
                if (!rangeWasChanged && !bms.isEmpty()) {
                    DomNodeController.logger.log(Level.FINEST, "{0}: the scale is bound, so adjust the range instead", AxisController.this.axis.id);
                    DatumRange dr = AxisController.this.axis.getRange();
                    Datum newW = AxisController.this.axis.getScale().multiply((double)npixels);
                    DatumRange newRange = DatumRangeUtil.createCentered((Datum)dr.middle(), (Datum)newW);
                    AxisController.this.axis.setRange(newRange);
                } else {
                    AxisController.this.axis.setScale(scale);
                }
            }
        }

        public String toString() {
            return "scaleListener " + this.hashCode() + " for " + AxisController.this.axis;
        }
    };

    public AxisController(Application dom, Plot plot, Axis axis, DasAxis dasAxis) {
        super(axis);
        this.dom = dom;
        this.dasAxis = dasAxis;
        this.plot = plot;
        this.axis = axis;
        axis.controller = this;
        if (plot.zaxis == axis) {
            this.defaultOppositeRight = true;
        }
        this.bindTo();
        axis.addPropertyChangeListener(this.rangeChangeListener);
    }

    public boolean valueIsAdjusting() {
        return super.isValueAdjusting() || this.dasAxis.valueIsAdjusting();
    }

    public void setRangeAutomatically(DatumRange range, boolean log) {
        boolean oldAutoRange = this.axis.autoRange;
        this.axis.setRange(range);
        this.axis.setLog(log);
        this.axis.autoRange = oldAutoRange;
    }

    public void setLabelAutomatically(String label) {
        if (this.axis.getLabel().contains("%{RANGE}") && !label.contains("%{RANGE}") && !this.axis.getLabel().contains("%{RANGE_NOORBIT}") && !label.contains("%{RANGE_NOORBIT}")) {
            return;
        }
        this.axis.setLabel(label);
        this.axis.setAutoLabel(true);
    }

    public void resetAxisUnits(Units nu) {
        DatumRange oldRange = this.dasAxis.getDatumRange();
        DatumRange newRange = DatumRange.newRange((double)oldRange.min().doubleValue(nu), (double)oldRange.max().doubleValue(nu), (Units)nu);
        this.dasAxis.resetRange(newRange);
        this.axis.setRange(newRange);
    }

    public void resetAxisRange(DatumRange newRange) {
        this.dasAxis.resetRange(newRange);
        this.axis.setRange(newRange);
    }

    private Converter getOppositeConverter(Axis axis, final DasAxis dasAxis) {
        return new Converter(){

            public Object convertForward(Object s) {
                int orientation = dasAxis.isHorizontal() ? (s.equals(Boolean.TRUE) ? 1 : 2) : (AxisController.this.defaultOppositeRight ? (s.equals(Boolean.TRUE) ? 3 : 4) : (s.equals(Boolean.TRUE) ? 4 : 3));
                return orientation;
            }

            public Object convertReverse(Object t) {
                int orientation = (Integer)t;
                return orientation == 1 || orientation == 4;
            }
        };
    }

    public final synchronized void bindTo() {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.axis, "range", this.dasAxis, "datumRange");
        ac.bind(this.axis, "log", this.dasAxis, "log");
        this.labelConverter = new LabelConverter(this.dom, this.plot, this.axis, null, null);
        this.labelConverter.setControlledNode(this.axis);
        ac.bind(this.axis, "label", this.dasAxis, "label", this.labelConverter);
        ac.bind(this.axis, "fontSize", this.dasAxis, "fontSize");
        ac.bind(this.axis, "drawTickLabels", this.dasAxis, "tickLabelsVisible");
        ac.bind(this.axis, "flipped", this.dasAxis, "flipped");
        ac.bind(this.axis, "visible", this.dasAxis, "visible");
        ac.bind(this.axis, "opposite", this.dasAxis, "orientation", this.getOppositeConverter(this.axis, this.dasAxis));
        ac.bind(this.axis, "tickValues", this.dasAxis, "tickValues");
        ac.bind(this.axis, "tickFormat", this.dasAxis, "format");
        ac.bind(this.axis, "reference", this.dasAxis, "reference");
        ac.bind(this.axis, "axisOffset", this.dasAxis, "axisOffset");
        this.column = this.dasAxis.getColumn();
        this.row = this.dasAxis.getRow();
        if (this.dasAxis.isHorizontal()) {
            this.column.addPropertyChangeListener(this.scaleListener);
        } else {
            this.row.addPropertyChangeListener(this.scaleListener);
        }
        this.axis.addPropertyChangeListener("range", this.scaleListener);
        this.axis.addPropertyChangeListener("log", this.scaleListener);
    }

    public final synchronized void removeBindings() {
        this.axis.removePropertyChangeListener("range", this.scaleListener);
        this.axis.removePropertyChangeListener("log", this.scaleListener);
        this.labelConverter = null;
        if (this.dasAxis.isHorizontal()) {
            this.column.removePropertyChangeListener(this.scaleListener);
        } else {
            this.row.removePropertyChangeListener(this.scaleListener);
        }
        this.dom.controller.unbind(this.axis);
        this.axis.removePropertyChangeListener(this.rangeChangeListener);
    }

    public final synchronized void removeReferences() {
        this.labelConverter = null;
    }

    public DasAxis getDasAxis() {
        return this.dasAxis;
    }

    void syncTo(DomNode n, List<String> exclude) {
        DasAxis.Lock lock = null;
        if (this.dasAxis != null) {
            lock = this.dasAxis.mutatorLock();
            lock.lock();
        }
        Axis that = (Axis)n;
        if (!exclude.contains("log")) {
            this.axis.setLog(that.isLog());
        }
        if (!exclude.contains("flipped")) {
            this.axis.setFlipped(that.isFlipped());
        }
        if (!exclude.contains("opposite")) {
            this.axis.setOpposite(that.isOpposite());
        }
        if (!exclude.contains("range")) {
            this.axis.setRange(that.getRange());
        }
        if (!exclude.contains("scale")) {
            this.axis.setScale(that.getScale());
        }
        if (!exclude.contains("label")) {
            this.axis.setLabel(that.getLabel());
        }
        if (!exclude.contains("fontSize")) {
            this.axis.setFontSize(that.getFontSize());
        }
        if (!exclude.contains("autoRange")) {
            this.axis.setAutoRange(that.isAutoRange());
        }
        if (!exclude.contains("autoLabel")) {
            this.axis.setAutoLabel(that.isAutoLabel());
        }
        if (!exclude.contains("autoRangeHints")) {
            this.axis.setAutoRangeHints(that.getAutoRangeHints());
        }
        if (!exclude.contains("drawTickLabels")) {
            this.axis.setDrawTickLabels(that.isDrawTickLabels());
        }
        if (!exclude.contains("tickValues")) {
            this.axis.setTickValues(that.getTickValues());
        }
        if (!exclude.contains("tickFormat")) {
            this.axis.setTickFormat(that.getTickFormat());
        }
        if (!exclude.contains("reference")) {
            this.axis.setReference(that.getReference());
        }
        if (!exclude.contains("visible")) {
            this.axis.setVisible(that.isVisible());
        }
        if (!exclude.contains("axisOffset")) {
            this.axis.setAxisOffset(that.getAxisOffset());
        }
        if (lock != null) {
            lock.unlock();
        }
    }
}

